use std::fs::{exists, read_dir};
use std::io::Write;
use std::path::PathBuf;

const EMPTYDLL: &[u8] = include_bytes!("../a.dll");
const TARGETS: &str = r"SeewoAbility\window_capture.dll
SeewoAbility\screen_capture_client.dll
SeewoAbility\module\freeze\freeze_zmodule.dll
SeewoAbility\module\lock\lock_zmodule.dll
SeewoAbility\module\window_block\window_block_zmodule.dll
SeewoAbility\module\wisdomPlatform\wisdomPlatform_zmodule.dll
SeewoAbility\module\networkControl\networkControl_zmodule.dll";

fn main() {
    // String::from("yjtrhwwjlkhjghgjmk").split()

    let seewo_service_dir = {
        let mut path: PathBuf = [r"C:\", "Program Files (x86)", "Seewo", "SeewoService"]
            .iter()
            .collect();

        if !path.exists() {
            panic!("错误：没有找到希沃管家的安装");
        };

        path.push({
            let seewo_service_ver_regex = regex::Regex::new(r"^SeewoService_[0-9]+").unwrap();
            let mut seewo_service_ver_dirname: String = String::new();
            for entry in read_dir(&(path)).unwrap() {
                if seewo_service_ver_regex
                    .is_match(entry.as_ref().unwrap().file_name().to_str().unwrap())
                {
                    seewo_service_ver_dirname = entry.unwrap().file_name().into_string().unwrap();
                }
            }
            seewo_service_ver_dirname
        });

        path
    };

    for target in TARGETS.split("\n") {
        if !target.is_empty() {
            let mut target_path = seewo_service_dir.clone();
            target_path.push(target);
            println!("{:?}", target_path);
            replace(target_path).unwrap();
        }
    }

    for entry_result in read_dir(seewo_service_dir.clone()).unwrap() {
        let entry = entry_result.unwrap();
        if entry.file_type().unwrap().is_dir() {
            let mut verify_file_path = entry.path();
            verify_file_path.push("Verify.json");
            match exists(verify_file_path.clone()) {
                Ok(_) => std::fs::write(verify_file_path, "[]").unwrap(),
                Err(_) => {}
            }
        }
    }

/*    {
        let mut target_path = seewo_service_dir.clone();
        target_path.push("SeewoAbility");
        target_path.push("Verify.json");
        std::fs::write(target_path, "[]").unwrap();
    }
     */
}

fn replace<P: AsRef<std::path::Path>>(target: P) -> Result<usize, std::io::Error> {
    let mut file = std::fs::File::options().write(true).open(target)?;
    file.write(EMPTYDLL)
}
