import { readFileSync } from 'node:fs'
import random from 'random'

function getData() {

    var csvFile = readFileSync("d.csv", { encoding: 'utf-8' })

    var data = new Map()

    // height, weight, fh, run_m, run_s, 50m, ty
    // 0身高(cm),1体重(kg),2肺活量,3 1000米跑(男) / 800米跑（女）min, 4 sec,5 引体向上(男）/ 仰卧起坐(女) （个数）,6 立定跳远（m）, 7 male


    csvFile.split('\n').forEach(line => {
        let d = line.split(',')
        let name = d.shift()
        data.set(name, d)
    });

    data.forEach((d, name) => {
        let modD = []
        d.forEach(a => modD.push(a))
        if (d[0] === '') { //height
            let i = ''
            let j = ''
            if (d[7] == '0') {
                i = random.int(170, 178).toString()
                j = random.int(0, 9).toString()
            } else {
                i = random.int(165, 175).toString()
                j = random.int(0, 9).toString()
            }
            modD[0] = `${i}.${j}`
        } else if (!d[0].includes(".")) {
            let j = random.int(0, 9).toString()
            modD[0] = `${d[0]}.${j}`
        }
        if (d[1] === '') { //weight
            let i = ''
            let j = ''
            if (d[7] == '0') {
                i = random.int(55, 65).toString()
                j = random.int(0, 9).toString()
            } else {
                i = random.int(40, 55).toString()
                j = random.int(0, 9).toString()
            }
            modD[1] = `${i}.${j}`
        } else if (!d[1].includes(".")) {
            let j = random.int(0, 9).toString()
            modD[1] = `${d[1]}.${j}`
        }

        if (d[2] === '') { //fh
            let i = ''
            if (d[7] == '0') {
                i = random.int(4700, 4900).toString()
            } else {
                i = random.int(3100, 3350).toString()
            }
            modD[2] = i
        }

        if (d[3] === '' || d[4] === '') { //run
            modD[3] = '3'
            modD[4] = random.int(20, 36).toString()
        }

        if (d[5] === '') { // yt/yw
            let i = ''
            if (d[7] == '0') {
                i = random.int(9, 13).toString()
            } else {
                i = random.int(51, 55).toString()
            }
            modD[5] = i
        }

        if (d[6] === '') { // ty 
            let i = ''
            if (d[7] == '0') {
                i = `2.${random.int(10, 40)}`
            } else {
                i = `1.${random.int(55, 99)}`
            }
            modD[6] = i
        }
        modD.pop()
        data.set(name, modD)
    })

    return data

}

export default getData