#![windows_subsystem = "windows"]

#[cfg(target_os = "linux")]
use std::os::unix::process::CommandExt;

//#[cfg(target_os = "windows")]
//use std::os::windows::process::CommandExt;

use chrono::prelude::*;
use encoding::Encoding;
use tokio::fs::OpenOptions;
use tokio::io::AsyncWriteExt;

const RAINMETER_EXECUTABLE: &str = "C:/opt/Rainmeter/Rainmeter.exe";
const API_URL: &str = "https://steve.alexxu.icu/api/today";

const SOURCE_CONTENT_BASE: &str = include_str!("rainmeter/Content.ini");
const SOURCE_TITLE_BASE: &str = include_str!("rainmeter/Title.ini");
const SOURCE_COUNTDOWN_BASE: &str = include_str!("rainmeter/Countdown.ini");

const TARGET_CONTENT_PATH: &str =
    "D:/Users/seewo/Documents/Rainmeter/Skins/Steve/Content/Content.ini";
const TARGET_TITLE_PATH: &str = "D:/Users/seewo/Documents/Rainmeter/Skins/Steve/Title/Title.ini";
const TARGET_COUNTDOWN_PATH: &str =
    "D:/Users/seewo/Documents/Rainmeter/Skins/Steve/Countdown/Countdown.ini";

#[tokio::main]
async fn main() {
    match reqwest::get(API_URL).await {
        Ok(res) => {
            if res.status().as_u16() == 404 {
                handle_fetch_err(true).await
            } else {
                let mut rainmeter_content_file = OpenOptions::new()
                    .create(true)
                    .write(true)
                    .truncate(true)
                    .open(TARGET_CONTENT_PATH)
                    .await
                    .unwrap();
                let mut rainmeter_title_file = OpenOptions::new()
                    .create(true)
                    .write(true)
                    .truncate(true)
                    .open(TARGET_TITLE_PATH)
                    .await
                    .unwrap();

                rainmeter_content_file
                    .write(
                        &(gbk(format!(
                            "{}{}",
                            SOURCE_CONTENT_BASE,
                            res.text().await.unwrap()
                        ))),
                    )
                    .await
                    .expect(&(format!("无法写入文件 {}", TARGET_CONTENT_PATH)));
                rainmeter_title_file
                    .write(&(gbk(String::from(SOURCE_TITLE_BASE))))
                    .await
                    .expect(&(format!("无法写入文件 {}", TARGET_TITLE_PATH)));
            }
        }
        Err(_err) => handle_fetch_err(false).await,
    };

    {
        let mut rainmeter_countdown_file = OpenOptions::new()
            .create(true)
            .write(true)
            .truncate(true)
            .open(TARGET_COUNTDOWN_PATH)
            .await
            .unwrap();

        rainmeter_countdown_file.write(&(gbk(format!("{}{}", SOURCE_COUNTDOWN_BASE, countdown())))).await.expect(&(format!("无法写入文件 {}", TARGET_COUNTDOWN_PATH)));
    };

    let _ = std::process::Command::new(RAINMETER_EXECUTABLE).spawn();
}

fn gbk(input: String) -> Vec<u8> {
    encoding::all::GBK
        .encode(&input, encoding::EncoderTrap::Ignore)
        .unwrap()

    
}

async fn handle_fetch_err(is_404: bool) {
    let mut rainmeter_title_file = OpenOptions::new()
        .create(true)
        .write(true)
        .truncate(true)
        .open(TARGET_TITLE_PATH)
        .await
        .unwrap();

    let err_content = match is_404 {
        true => "[未更新]",
        false => "[获取失败]",
    };

    rainmeter_title_file
        .write(&(gbk(format!("{} {}", SOURCE_TITLE_BASE, err_content))))
        .await
        .expect(&(format!("无法写入文件 {}", TARGET_TITLE_PATH)));
}

fn countdown() -> String {
    let time = Local::now();
    let year = match NaiveDate::from_ymd_opt(time.year(), time.month(), time.day()).unwrap()
        > time.date_naive()
    {
        true => time.year(),
        false => time.year() + 1,
    };
    let delta = NaiveDate::from_ymd_opt(year, 6, 7).unwrap() - time.date_naive();
    format!("距 {} 年高考仅剩 {} 天", year, delta.num_days())
}
