/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.tcdcommons.TCDCommons;
import java.io.InputStream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BetterStatsProperties {
    private static final JsonObject MOD_PROPERTIES;
    public static final String URL_SOURCES;
    public static final String URL_ISSUES;
    public static final String URL_CURSEFORGE;
    public static final String URL_MODRINTH;
    public static final String URL_WEBSITE;
    public static final String URL_YOUTUBE;
    public static final String URL_FEEDBACK;
    public static final String URL_FV;
    public static final String URL_QS_LEGAL;
    public static final String URL_REMOTE_APIS;

    public static final void init() {
    }

    @ApiStatus.Internal
    public static final JsonObject getModProperties() {
        return MOD_PROPERTIES;
    }

    static {
        try {
            InputStream propertiesStream = BetterStats.class.getResourceAsStream("/betterstats.properties.json");
            String propertiesJsonStr = new String(propertiesStream.readAllBytes());
            propertiesStream.close();
            MOD_PROPERTIES = (JsonObject)TCDCommons.GSON.fromJson(propertiesJsonStr, JsonObject.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        JsonObject links = MOD_PROPERTIES.get("links").getAsJsonObject();
        URL_SOURCES = links.get("sources").getAsString();
        URL_ISSUES = links.get("issues").getAsString();
        URL_CURSEFORGE = links.get("curseforge").getAsString();
        URL_MODRINTH = links.get("modrinth").getAsString();
        URL_WEBSITE = links.get("website").getAsString();
        URL_YOUTUBE = links.get("youtube").getAsString();
        URL_FEEDBACK = links.get("feedback").getAsString();
        URL_FV = links.get("full_version").getAsString();
        URL_QS_LEGAL = links.get("quickshare_legal").getAsString();
        URL_REMOTE_APIS = links.get("remote_api_links").getAsString();
    }
}

