/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class SUMobStat
extends SUStat<class_1299<?>> {
    protected final class_1299<?> entityType;
    protected final boolean isEmpty;
    public final int kills;
    public final int deaths;

    public SUMobStat(IStatsProvider statsProvider, class_1299<?> entityType) {
        super(statsProvider, class_7923.field_41177.method_10221(Objects.requireNonNull(entityType)), SUMobStat.getMobStatText(entityType));
        this.entityType = entityType;
        this.kills = statsProvider.getStatValue(class_3468.field_15403, entityType);
        this.deaths = statsProvider.getStatValue(class_3468.field_15411, entityType);
        this.isEmpty = this.kills == 0 && this.deaths == 0;
    }

    public final class_1299<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static final class_2561 getMobStatText(class_1299<?> entityType) {
        return TextUtils.fTranslatable((String)entityType.method_5882(), (Object[])new Object[0]);
    }

    public static List<SUMobStat> getMobStats(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        ArrayList<SUMobStat> result = new ArrayList<SUMobStat>();
        for (class_1299 entityType : class_7923.field_41177) {
            SUMobStat mobStat = new SUMobStat(statsProvider, entityType);
            if (filter != null && !filter.test(mobStat)) continue;
            result.add(mobStat);
        }
        return result;
    }

    public static Map<String, List<SUMobStat>> getMobStatsByModGroups(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        LinkedHashMap<String, List<SUMobStat>> result = new LinkedHashMap<String, List<SUMobStat>>();
        String mcModId = new class_2960("air").method_12836();
        result.put(mcModId, Lists.newArrayList());
        for (SUMobStat mobStat : SUMobStat.getMobStats(statsProvider, filter)) {
            String entityModId = mobStat.getStatID().method_12836();
            if (!result.containsKey(entityModId)) {
                result.put(entityModId, Lists.newArrayList());
            }
            Collection resultList = result.get(entityModId);
            resultList.add(mobStat);
        }
        if (((List)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static Map<class_2561, List<SUMobStat>> getMobStatsByModGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUMobStat> filter) {
        Map<String, List<SUMobStat>> stats = SUMobStat.getMobStatsByModGroups(statsProvider, filter);
        LinkedHashMap<class_2561, List<SUMobStat>> mapped = new LinkedHashMap<class_2561, List<SUMobStat>>();
        for (Map.Entry<String, List<SUMobStat>> entry : stats.entrySet()) {
            class_5250 txt = entry.getKey() != null ? TextUtils.literal((String)TUtils.getModName((String)entry.getKey())) : TextUtils.literal((String)"*");
            mapped.put((class_2561)txt, entry.getValue());
        }
        return mapped;
    }
}

