/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.repo;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.registry.TMutableRegistry;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryUserInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.github.GitHubRepositoryInfoProvider;
import io.github.thecsdev.tcdcommons.api.util.io.repo.ugc.RepositoryInfo;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1255;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="v3.12", forRemoval=true)
public abstract class RepositoryInfoProvider {
    private static final String THREAD_NAME = TCDCommons.getModID() + ":" + RepositoryInfoProvider.class.getSimpleName().toLowerCase();
    private static final ExecutorService THREAD_SCHEDULER = Executors.newCachedThreadPool(task -> {
        Thread thread = new Thread(task, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });

    @ApiStatus.Internal
    static final <T> void getInfoAsync(class_1255<?> minecraftClientOrServer, Consumer<T> onReady, Consumer<Exception> onError, Callable<T> infoObtainer) throws NullPointerException {
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        Objects.requireNonNull(infoObtainer);
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        AtomicReference<Object> raisedException = new AtomicReference<Object>(null);
        THREAD_SCHEDULER.submit(() -> {
            try {
                result.set(infoObtainer.call());
            }
            catch (Exception exc) {
                raisedException.set(exc);
            }
            catch (Error err) {
                minecraftClientOrServer.method_40000(() -> {
                    throw err;
                });
                return;
            }
            minecraftClientOrServer.method_40000(() -> {
                if (result.get() == null && raisedException.get() == null) {
                    raisedException.set(new UnsupportedOperationException("Information fetching returned null."));
                }
                if (raisedException.get() != null) {
                    onError.accept((Exception)raisedException.get());
                } else {
                    onReady.accept(result.get());
                }
            });
        });
    }

    public static final void getRepoInfoAsync(URI repoUri, class_1255<?> minecraftClientOrServer, Consumer<@Nullable RepositoryInfo> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(repoUri);
        RepositoryInfoProvider.getInfoAsync(minecraftClientOrServer, onReady, onError, () -> {
            TMutableRegistry<RepositoryInfoProvider> tMutableRegistry = TRegistries.REPO_INFO_PROVIDER;
            synchronized (tMutableRegistry) {
                for (Map.Entry entry : TRegistries.REPO_INFO_PROVIDER) {
                    RepositoryInfoProvider rip = (RepositoryInfoProvider)entry.getValue();
                    RepositoryInfo ri = rip.fetchRepoInfoSync(repoUri);
                    if (ri == null) continue;
                    return ri;
                }
                return null;
            }
        });
    }

    public static final void getUserInfoAsync(URI userUri, class_1255<?> minecraftClientOrServer, Consumer<@Nullable RepositoryUserInfo> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(userUri);
        RepositoryInfoProvider.getInfoAsync(minecraftClientOrServer, onReady, onError, () -> {
            TMutableRegistry<RepositoryInfoProvider> tMutableRegistry = TRegistries.REPO_INFO_PROVIDER;
            synchronized (tMutableRegistry) {
                for (Map.Entry entry : TRegistries.REPO_INFO_PROVIDER) {
                    RepositoryInfoProvider rip = (RepositoryInfoProvider)entry.getValue();
                    RepositoryUserInfo ri = rip.fetchUserInfoSync(userUri);
                    if (ri == null) continue;
                    return ri;
                }
                return null;
            }
        });
    }

    @Nullable
    public abstract RepositoryInfo fetchRepoInfoSync(URI var1) throws NullPointerException, IOException;

    @Nullable
    public abstract RepositoryUserInfo fetchUserInfoSync(URI var1) throws NullPointerException, IOException;

    public static final String[] getUriPathEntries(URI uri) throws NullPointerException {
        Objects.requireNonNull(uri);
        String path = uri.getPath();
        if (path == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(path.split("/")).filter(s -> !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{s})).toArray(String[]::new);
    }

    static {
        TRegistries.REPO_INFO_PROVIDER.register(new class_2960(TCDCommons.getModID(), "github"), GitHubRepositoryInfoProvider.getInstance());
    }
}

